#include "Log.h"

const char* FILENAME_LOG = "u4aapi.log";
log *log::_instance = NULL;

log::log() {

    int len;
    logFile = new fstream();
    // Verifico que no exceda el tamano maximo del log
    logFile->open(FILENAME_LOG, ios::binary | ios_base::in);
    logFile->seekg (0, ios::end);
    len = (int) logFile->tellg();
    logFile->close();
    delete logFile;

    if (len > MAX_LOG) {
        // Si excede elimino los archivos.
        logFile = new fstream();
        logFile->open(FILENAME_LOG, ios_base::trunc | ios_base::out);
        logFile->close();
        delete logFile;
    }
    logFile = new fstream();
    logFile->open(FILENAME_LOG, ios_base::app | ios_base::out );
    *logFile << endl << " -- Comienzo del Log --" << endl << endl;
}

string log::getTime() {

    time_t tiempo;
    char cad[80];
    struct tm *tmPtr;
    tiempo = time(NULL);
    tmPtr = localtime(&tiempo);
    strftime( cad, 80, "[%d/%m/%y-%H:%M.%S]", tmPtr );
    return string(cad);
}

log* log::instance() {

    if (_instance == NULL)
        _instance = new log();
    return _instance;
}

void log::printLog(char *m, bool enter, bool timestamp) {

    if (logFile->is_open()) {
        if (enter)
            *logFile << getTime() << " " << m << " " << endl;
        else if (timestamp)
            *logFile << getTime() << " " << m << " ";
        else
            *logFile << " " << m << " ";
    }
}

void log::printLogLn() {

    if (logFile->is_open()) {
        *logFile << endl;
    }
}

log::~log() {

    if (logFile->is_open()) {
        *logFile << endl << " -- Fin del Log --";
        logFile->close();
    }
}
